<?php
include 'db.php';

// Get active playlist based on current time
$now = date('Y-m-d H:i:s');
$stmt = $pdo->prepare("SELECT * FROM schedules WHERE start_time <= ? AND end_time >= ?");
$stmt->execute([$now, $now]);
$schedule = $stmt->fetch();

if ($schedule) {
    $playlistId = $schedule['playlist_id'];
    $items = $pdo->prepare("SELECT c.* FROM playlist_items pi 
                            JOIN content c ON pi.content_id=c.id 
                            WHERE pi.playlist_id=? ORDER BY pi.position");
    $items->execute([$playlistId]);
    $content = $items->fetchAll();
}
?>
<div>
  <?php foreach ($content as $item): ?>
    <?php if ($item['type'] == 'image'): ?>
      <img src="uploads/<?php echo $item['filename']; ?>" style="width:100%;" />
    <?php else: ?>
      <video src="uploads/<?php echo $item['filename']; ?>" controls autoplay></video>
    <?php endif; ?>
  <?php endforeach; ?>
</div>
