<?php
session_start();
include 'db.php';

// Handle AJAX save
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['playlist_id'])) {
    $playlistId = $_POST['playlist_id'];
    $start = $_POST['start'];
    $end = $_POST['end'];

    $stmt = $pdo->prepare("INSERT INTO schedules (playlist_id, start_time, end_time) VALUES (?, ?, ?)");
    $stmt->execute([$playlistId, $start, $end]);
    echo json_encode(["status" => "success"]);
    exit;
}

// Fetch schedules for calendar
$stmt = $pdo->query("SELECT s.id, p.name, s.start_time, s.end_time 
                     FROM schedules s 
                     JOIN playlists p ON s.playlist_id=p.id");
$schedules = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
  <title>Schedule Calendar</title>
  <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>
  <style>
    #calendar { max-width: 900px; margin: 40px auto; }
  </style>
</head>
<body>
<h2>Playlist Schedule Calendar</h2>
<div id="calendar"></div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  let calendarEl = document.getElementById('calendar');
  let calendar = new FullCalendar.Calendar(calendarEl, {
    initialView: 'dayGridMonth',
    selectable: true,
    events: [
      <?php foreach ($schedules as $s): ?>
        {
          id: '<?php echo $s['id']; ?>',
          title: '<?php echo $s['name']; ?>',
          start: '<?php echo $s['start_time']; ?>',
          end: '<?php echo $s['end_time']; ?>'
        },
      <?php endforeach; ?>
    ],
    select: function(info) {
      let playlistId = prompt("Enter Playlist ID to schedule:");
      if (playlistId) {
        let formData = new FormData();
        formData.append("playlist_id", playlistId);
        formData.append("start", info.startStr);
        formData.append("end", info.endStr);

        fetch("schedule_calendar.php", {
          method: "POST",
          body: formData
        }).then(res => res.json()).then(data => {
          if (data.status === "success") {
            alert("Schedule saved!");
            location.reload();
          }
        });
      }
    }
  });
  calendar.render();
});
</script>
</body>
</html>
