-- Insert an admin user
INSERT INTO users (email, password, role)
VALUES ('admin@example.com', 
        '$2y$10$QeWlY7yFhX9ZkQhDkYkV6uYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYw', 
        'admin');
-- Password is "password" (hashed with bcrypt)

-- Insert an editor user
INSERT INTO users (email, password, role)
VALUES ('editor@example.com', 
        '$2y$10$QeWlY7yFhX9ZkQhDkYkV6uYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYw', 
        'editor');

-- Insert a viewer user
INSERT INTO users (email, password, role)
VALUES ('viewer@example.com', 
        '$2y$10$QeWlY7yFhX9ZkQhDkYkV6uYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYwYw', 
        'viewer');

-- Demo content (images/videos)
INSERT INTO content (filename, type, uploaded_by) VALUES
('demo_image1.jpg', 'image', 1),
('demo_image2.png', 'image', 1),
('demo_video1.mp4', 'video', 1);

-- Demo playlist
INSERT INTO playlists (name, created_by) VALUES ('Demo Playlist', 1);

-- Playlist items
INSERT INTO playlist_items (playlist_id, content_id, position) VALUES
(1, 1, 1),
(1, 2, 2),
(1, 3, 3);

-- Demo schedule
INSERT INTO schedules (playlist_id, start_time, end_time) VALUES
(1, '2026-02-24 09:00:00', '2026-02-24 17:00:00');

-- Demo activity logs
INSERT INTO activity_logs (user_id, action, details) VALUES
(1, 'Upload', 'Uploaded demo_image1.jpg'),
(1, 'Upload', 'Uploaded demo_video1.mp4'),
(1, 'Playlist', 'Created Demo Playlist'),
(1, 'Schedule', 'Scheduled Demo Playlist for Feb 24, 2026');
