<?php
session_start();
include 'db.php';

// Fetch all playlists for current user
$stmt = $pdo->prepare("SELECT * FROM playlists WHERE created_by=?");
$stmt->execute([$_SESSION['user_id']]);
$playlists = $stmt->fetchAll();

// If order is updated
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['order'])) {
    $order = json_decode($_POST['order'], true);
    foreach ($order as $position => $contentId) {
        $update = $pdo->prepare("UPDATE playlist_items SET position=? WHERE content_id=?");
        $update->execute([$position, $contentId]);
    }
    echo "Order updated!";
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Playlist Editor</title>
  <style>
    ul { list-style:none; padding:0; }
    li { padding:10px; margin:5px; background:#eee; cursor:move; border:1px solid #ccc; }
  </style>
</head>
<body>
<h2>Drag & Drop Playlist Editor</h2>

<?php foreach ($playlists as $playlist): ?>
  <h3><?php echo $playlist['name']; ?></h3>
  <ul id="playlist-<?php echo $playlist['id']; ?>">
    <?php
      $items = $pdo->prepare("SELECT c.* FROM playlist_items pi 
                              JOIN content c ON pi.content_id=c.id 
                              WHERE pi.playlist_id=? ORDER BY pi.position");
      $items->execute([$playlist['id']]);
      foreach ($items as $item): ?>
        <li draggable="true" data-id="<?php echo $item['id']; ?>">
          <?php echo $item['filename']; ?> (<?php echo $item['type']; ?>)
        </li>
    <?php endforeach; ?>
  </ul>
  <button onclick="saveOrder(<?php echo $playlist['id']; ?>)">Save Order</button>
<?php endforeach; ?>

<script>
  let dragged;

  document.addEventListener("dragstart", function(e) {
    dragged = e.target;
    e.target.style.opacity = 0.5;
  });

  document.addEventListener("dragend", function(e) {
    e.target.style.opacity = "";
  });

  document.addEventListener("dragover", function(e) {
    e.preventDefault();
  });

  document.addEventListener("drop", function(e) {
    e.preventDefault();
    if (e.target.tagName === "LI" && dragged !== e.target) {
      let parent = e.target.parentNode;
      parent.insertBefore(dragged, e.target.nextSibling);
    }
  });

  function saveOrder(playlistId) {
    let list = document.getElementById("playlist-" + playlistId);
    let ids = [];
    list.querySelectorAll("li").forEach((li, index) => {
      ids.push(li.dataset.id);
    });

    let formData = new FormData();
    formData.append("order", JSON.stringify(ids));

    fetch("playlist_editor.php", {
      method: "POST",
      body: formData
    }).then(res => res.text()).then(data => alert(data));
  }
</script>
</body>
</html>
