<?php
session_start();
include 'db.php';

// Check login
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <title>Digital Display Admin Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>
  <style>
    body { font-family: Arial, sans-serif; margin:0; background:#f4f4f4; }
    header { background:#333; color:#fff; padding:10px; text-align:center; }
    nav { display:flex; background:#444; }
    nav button { flex:1; padding:12px; border:none; background:#444; color:#fff; cursor:pointer; }
    nav button.active { background:#222; }
    section { display:none; padding:20px; background:#fff; margin:20px; border-radius:8px; }
    section.active { display:block; }
    ul { list-style:none; padding:0; }
    li { padding:10px; margin:5px; background:#eee; cursor:move; border:1px solid #ccc; }
    #calendar { max-width: 900px; margin: 20px auto; }
  </style>
</head>
<body>

<header>
  <h1>Digital Display Admin Dashboard</h1>
</header>

<nav>
  <button onclick="showTab('upload')" class="active">Upload</button>
  <button onclick="showTab('playlist')">Playlist Editor</button>
  <button onclick="showTab('schedule')">Schedule Calendar</button>
  <button onclick="showTab('slideshow')">Slideshow</button>
</nav>

<section id="upload" class="active">
  <h2>Upload Content</h2>
  <form method="POST" action="upload.php" enctype="multipart/form-data">
    <input type="file" name="file" required />
    <button type="submit">Upload</button>
  </form>
</section>

<section id="playlist">
  <h2>Playlist Editor</h2>
  <?php
    $stmt = $pdo->prepare("SELECT * FROM playlists WHERE created_by=?");
    $stmt->execute([$_SESSION['user_id']]);
    $playlists = $stmt->fetchAll();
    foreach ($playlists as $playlist):
  ?>
    <h3><?php echo $playlist['name']; ?></h3>
    <ul id="playlist-<?php echo $playlist['id']; ?>">
      <?php
        $items = $pdo->prepare("SELECT c.* FROM playlist_items pi 
                                JOIN content c ON pi.content_id=c.id 
                                WHERE pi.playlist_id=? ORDER BY pi.position");
        $items->execute([$playlist['id']]);
        foreach ($items as $item): ?>
          <li draggable="true" data-id="<?php echo $item['id']; ?>">
            <?php echo $item['filename']; ?> (<?php echo $item['type']; ?>)
          </li>
      <?php endforeach; ?>
    </ul>
    <button onclick="saveOrder(<?php echo $playlist['id']; ?>)">Save Order</button>
  <?php endforeach; ?>
</section>

<section id="schedule">
  <h2>Schedule Calendar</h2>
  <div id="calendar"></div>
</section>

<section id="slideshow">
  <h2>Slideshow Preview</h2>
  <iframe src="slideshow.php" width="100%" height="400"></iframe>
</section>

<script>
function showTab(tabId) {
  document.querySelectorAll("nav button").forEach(btn => btn.classList.remove("active"));
  document.querySelectorAll("section").forEach(sec => sec.classList.remove("active"));
  document.querySelector("nav button[onclick=\"showTab('" + tabId + "')\"]").classList.add("active");
  document.getElementById(tabId).classList.add("active");
}

// Drag & Drop Playlist
let dragged;
document.addEventListener("dragstart", e => { dragged = e.target; e.target.style.opacity = 0.5; });
document.addEventListener("dragend", e => { e.target.style.opacity = ""; });
document.addEventListener("dragover", e => e.preventDefault());
document.addEventListener("drop", e => {
  e.preventDefault();
  if (e.target.tagName === "LI" && dragged !== e.target) {
    let parent = e.target.parentNode;
    parent.insertBefore(dragged, e.target.nextSibling);
  }
});
function saveOrder(playlistId) {
  let list = document.getElementById("playlist-" + playlistId);
  let ids = [];
  list.querySelectorAll("li").forEach(li => ids.push(li.dataset.id));
  let formData = new FormData();
  formData.append("order", JSON.stringify(ids));
  fetch("playlist_editor.php", { method: "POST", body: formData })
    .then(res => res.text()).then(data => alert(data));
}

// FullCalendar Setup
document.addEventListener('DOMContentLoaded', function() {
  let calendarEl = document.getElementById('calendar');
  let calendar = new FullCalendar.Calendar(calendarEl, {
    initialView: 'dayGridMonth',
    selectable: true,
    events: [
      <?php
        $stmt = $pdo->query("SELECT s.id, p.name, s.start_time, s.end_time 
                             FROM schedules s 
                             JOIN playlists p ON s.playlist_id=p.id");
        foreach ($stmt as $s): ?>
          { id: '<?php echo $s['id']; ?>', title: '<?php echo $s['name']; ?>', start: '<?php echo $s['start_time']; ?>', end: '<?php echo $s['end_time']; ?>' },
      <?php endforeach; ?>
    ],
    select: function(info) {
      let playlistId = prompt("Enter Playlist ID to schedule:");
      if (playlistId) {
        let formData = new FormData();
        formData.append("playlist_id", playlistId);
        formData.append("start", info.startStr);
        formData.append("end", info.endStr);
        fetch("schedule_calendar.php", { method: "POST", body: formData })
          .then(res => res.json()).then(data => {
            if (data.status === "success") { alert("Schedule saved!"); location.reload(); }
          });
      }
    }
  });
  calendar.render();
});
</script>
</body>
</html>
